<?php

namespace App\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event to listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        \App\Events\JobPosted::class => [
            \App\Listeners\SendJobPostedNotification::class,
        ],
        \App\Events\JobApplied::class => [
            \App\Listeners\SendJobAppliedNotification::class,
        ],
        \App\Events\InterviewStatusChanged::class => [
            \App\Listeners\SendInterviewStatusNotification::class,
        ],
        \App\Events\LessonCompletedEvent::class => [ // Added for video progress update
            \App\Listeners\UpdateCourseProgressListener::class,
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
